<?php
/**
* @package direct-as-a-service
* @subpackage views
 * @filesource
*/ /** */

	$this->load->view('api/header'); 
	$this->load->view('api/nav'); 
	$this->load->helper('form');
?>
				<h1>Onboarding</h1>
				<div class="column">
					<?php if(!$registered && $status === 'Approved') {?>
						<div class="message_error">
							<p>Your account is currently disabled, contact an administrator to request access.</p>
						</div>
					<?php } ?>
					<div class="left">
						<h3>The Direct Project</h3>
						<p>
							The Direct Project is an open government initiative sponsored by the Office of the 
							National Coordinator for Health Information Technology (ONC) under the Department of Health 
							and Human Services (HHS). ONC developed the Direct specification for a simple, secure, 
							scalable and standards-based protocol to send encrypted, electronic health information 
							directly to known, trusted recipients over the internet. The Meaningful Use Stage 2 Final 
							Rule, released in September 4, 2012, requires support for Direct Project to qualify for 
							federal Electronic Health Record (EHR) certification; 49 State Health Information Exchanges 
							(HIEs) have planned support for Direct Project as part of the federal State HIE grant 
							program. These two factors make the Direct Project a major focus of the national HIE 
							strategy and could lead to ubiquitous use among Network Providers in the near future.
						</p>
						<h3>Application Programming Interface (API) Documentation</h3>
						<p>
							<?PHP echo PRODUCT_NAME;?> provides the centralized management of the security, trust and 
							routing of Direct messages for the VA. This gives applications the ability to leverage 
							the Direct messaging protocol without having to develop any new infrastructure.  
							<?PHP echo PRODUCT_NAME;?> provides VA clinical systems access to the Direct Architecture via common, 
							secure web services. The "Send" web service provides trusted applications the ability to 
							send a Direct message to a trusted. The "Validate Trust" web service checks whether the 
							target addresses are trusted. The documentation, provided in the links below, contains 
							all the information necessary to connect an application to the API and use <?PHP echo PRODUCT_NAME;?>
							web services.
						</p>
						<p class="center">
							<input type="button" class="blue-button button-standard" onclick="location.href='/onboarding/send/'" value="Send"/>
							<input type="button" class="blue-button button-standard" onclick="location.href='/onboarding/validate/'" value="Validate Trust"/>
						</p>
						<p>
							<?php echo PRODUCT_NAME?> also provides "Message Management" web services that will allow VA clinical 
							systems the ability to create their own webmail GUI. These web services include "Messages" which allows you
							to query and receive different messages. The different folder web services allow you to create, rename, 
							archive and return a list of all folders for a specific mailbox. You can move messages between folders and also 
							receive a count of the number of messages in a given mailbox.
						</p>
						<p class="center">
							<input type="button" class="blue-button button-standard" onclick="location.href='/onboarding/message/'" value="Messages"/>
							<input type="button" class="blue-button button-standard" onclick="location.href='/onboarding/send_draft/'" value="Send Draft"/>
							<input type="button" class="blue-button button-standard" onclick="location.href='/onboarding/count/'" value="Count"/>
							<input type="button" class="blue-button button-standard" onclick="location.href='/onboarding/folders/'" value="Folders"/>
							<input type="button" class="blue-button button-standard" onclick="location.href='/onboarding/create_folder/'" value="Create Folder"/>
							<input type="button" class="blue-button button-standard" onclick="location.href='/onboarding/rename_folder/'" value="Rename Folder"/>
							<input type="button" class="blue-button button-standard" onclick="location.href='/onboarding/archive/'" value="Archive Message"/>
							<input type="button" class="blue-button button-standard" onclick="location.href='/onboarding/restore/'" value="Restore Message"/>
							<input type="button" class="blue-button button-standard" onclick="location.href='/onboarding/save/'" value="Save Message"/>
							<input type="button" class="blue-button button-standard" onclick="location.href='/onboarding/move/'" value="Move Message"/>
							<input type="button" class="blue-button button-standard" onclick="location.href='/onboarding/archive_folder/'" value="Archive Folder"/>
						</p>
					</div>
					
					<div class="right">
						<?PHP if($registered) { ?>
							<h3>Application Registration</h3>
							<p>
								Registered applications will be able to access and use <?PHP echo PRODUCT_NAME;?> web services. To 
								request application access, click on the "Request Application Access" button and provide the 
								information on the request form.
							</p>
							<p class="center">
								<input type="button" class="blue-button" onclick="location.href='/onboarding/request/'" value="Request Application Access"/>
							</p>
							<p>
								Once the application request form has been submitted, <?PHP echo PRODUCT_NAME;?> administrators will 
								be notified of pending requests awaiting approval. When the administrator approves the 
								application request, an email will be generated and sent to the Point of Contact (POC) noted 
								on the application request submission, indicating the application has received access to use 
								<?PHP echo PRODUCT_NAME;?> web services.
							</p>
							<p>
								If further information is needed to approve the application request, the <?PHP echo PRODUCT_NAME;?> 
								administrator will deny the request and provide a reason for denial and/or request further 
								information. An email notification will be sent to the requester to resubmit. A request may be 
								resubmitted, by navigating to the "Denied" tab on the application page. The application request 
								should be updated with the requested changes and resubmitted for review.
							</p>
						<?PHP } else {
							if ($status === 'Approved') { ?>
								<h3>Contact Administrators</h3>
								<?PHP if(isset($error_message)) { echo '<div class="message_error">'.$error_message.'</div>'; } ?>
								<?PHP if(isset($success_message)) { echo '<div class="message_success">'.$success_message.'</div>'; } ?>
								<?php if (!$sent_message) { ?>
									<p>
										If you would like to send a message to an Administrator please fill out the form below and click submit. An administrator will reach out to you for follow-up.
									</p>
									<?PHP echo form_open('/support/save',array('id'=>'contactForm')); ?>
										<div class="form" style="width:97%;">
											<?PHP echo form_hidden('type',$category); ?>
											<label for="support_message">Message:</label>
											<textarea id="support_message" name="support_message" class="wide"></textarea>
										</div>
										<div class="text-right"><input class="blue-button" type="submit" value="Save"/></div>	
									<?PHP echo form_close(); ?>
								<?php } else { ?>
									<div class="message">You have already sent a message within the past 24 hours. If you are not contacted by the end of the 24 hours you will be able to submit a new message.</div>
								<?php } ?>
							<?php } else { ?>
								<h3>User Registration</h3>
								<p>
									To create an account to the Direct Project API Admin Panel, select the link below titled, 
									"Request Account."  Registered users of the API Admin Panel will have the ability to request 
									access to the API web services for their application. In addition, the Direct Project API 
									Admin Panel allows users to manage application credentials, view application reports and usage 
									statistics, and request new application keys.
								</p>
								<p class="center">
									<input type="button" class="blue-button" onclick="location.href='/onboarding/request/'" value="Request Account"/>
								</p>
								<p>
									Once a user request form has been submitted, the <?PHP echo PRODUCT_NAME;?> administrators will be 
									notified of a pending account request awaiting approval. When an administrator approves the 
									account, an email will be sent indicating account access has been approved.
								</p>
								<p>
									If further information is needed to approve the user account request, the <?PHP echo PRODUCT_NAME;?> 
									administrator will deny the request and provide a reason for denial and/or request further 
									information. An email notification will be sent to the user to resubmit a request. A request 
									may be resubmitted, by simply, clicking the button titled, "Request Account Access". The 
									request will be resubmitted for review to the <?PHP echo PRODUCT_NAME;?> administrators.
								</p>
						<?PHP } //end if status approved
								} // end if registered ?>
					</div>
				</div>
			</div>
			<?PHP $this->load->view('api/footer'); ?>
		</div>
	</body>
</html>